extends KinematicBody

var mouse_sensitivity = 0.3
var direction:Vector3

func _physics_process(delta):
	var aim = $Head/Camera.get_camera_transform().basis
	if Input.is_action_pressed("ui_up"):
		direction -= aim.z
	if Input.is_action_pressed("ui_down"):
		direction += aim.z
	if Input.is_action_pressed("ui_left"):
		direction -= aim.x
	if Input.is_action_pressed("ui_right"):
		direction += aim.x
#	if Input.is_action_pressed("ui_page_up"):
#		direction += aim.y
#	if Input.is_action_pressed("ui_page_down"):
#		direction -= aim.y
	direction = direction.normalized()
	direction.y += -9.8 * delta
	
	var target = direction * 6.0
	move_and_slide(target)

func _input(event):
	if event is InputEventMouseMotion:
		$Head.rotate_y(deg2rad(-event.relative.x) * mouse_sensitivity)
		$Head/Camera.rotate_x(deg2rad(-event.relative.y) * mouse_sensitivity)

func teleport(spawn):
	look_at_from_position(spawn, Vector3(0,0,0),  Vector3(0,0,0))
